# -------------------------------------------------------- 
# SharePoint 2013 Advanced WCM - Sample Code 
# by John Chapman
# (c) Packt Publishing
#
# Import a design package to all site collections in all
# content web applications
# -------------------------------------------------------- 

# -------------------------------------------------------- 
# VARIABLES
# Replace the variable values appropriately
# -------------------------------------------------------- 

# Path of the design package
$filePath = "C:\Packages\My PowerShell Design-1.0.wsp" 

# Major version of the design package
$majorVersion = 1

# Minor version of the design package
$minorVersion = 0

# -------------------------------------------------------- 
# END VARIABLES
# -------------------------------------------------------- 

# -------------------------------------------------------- 
# SCRIPT
# -------------------------------------------------------- 

# Add the SharePoint PowerShell snap-in
Add-PSSnapin Microsoft.SharePoint.PowerShell -ErrorAction SilentlyContinue

# Load the required SharePoint assemblies
[Reflection.Assembly]::LoadFrom("C:\Program Files\Common Files\microsoft shared\Web Server Extensions\15\ISAPI\Microsoft.SharePoint.Publishing.dll")
[Reflection.Assembly]::LoadFrom("C:\Program Files\Common Files\microsoft shared\Web Server Extensions\15\ISAPI\Microsoft.SharePoint.dll")

# Get the File Name from the File Path
$fileName = [System.IO.Path]::GetFileName($filePath)

# Create a new Design Package Info object
$package = New-Object Microsoft.SharePoint.Publishing.DesignPackageInfo($fileName, [Guid]::Empty, $majorVersion, $minorVersion)

# Create a name for the temporary folders to be used when uploading the Design Package
$tempFolderName = "temp_designupload_" + ([Guid]::NewGuid).ToString()

# Open the file contents
$fileBinary = [System.IO.File]::OpenRead($filePath)

# Iterate through each Weh Application
foreach ($webApp in (Get-SPWebApplication))
{
	# Iterate through each Site collection in the Web Application
	foreach ($site in $webApp.Sites)
	{
		# Ensure the Site Collection is in 2013 mode
		if ($site.CompatibilityLevel eq 15)
		{
			# Create a temporary folder in the Site Collection
			$tempFolder = $site.RootWeb.RootFolder.SubFolders.Add($tempFolderName)

			# Upload the Design Package to the temporary folder
			$file = $tempFolder.Files.Add($fileName, $fileBinary, $true)

			# Install the Design Package
			[Microsoft.SharePoint.Publishing.DesignPackage]::Install($site, $package, $file.Url)

			# Remove the temporary folder
			$tempFolder.Delete()
		}

		# Dispose of the site collection object
		$site.Dispose()
	}
}

# Close the Design Package file
$fileBinary.Close()

# -------------------------------------------------------- 
# END SCRIPT
# --------------------------------------------------------